package ie.ucd.sixth.adaptor.davis;

import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import ie.ucd.sixth.core.adaptor.AbstractSensorNetworkAdaptor;
import ie.ucd.sixth.core.adaptor.IMessageTranslator;
import ie.ucd.sixth.core.adaptor.SensorMessageTranslationException;
import ie.ucd.sixth.core.misc.TaskingMessage;
import ie.ucd.sixth.core.sensor.data.ISensorData;
import ie.ucd.sixth.core.sensor.data.SensorData;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class SerialPortComm extends AbstractSensorNetworkAdaptor {

	private DavisAdaptor adaptor;

	public SerialPortComm(CommPortIdentifier portIdentifier, int baudRate,
			DavisAdaptor adaptor) throws Exception {
		this.adaptor = adaptor;
		// CommPortIdentifier portIdentifier =
		// CommPortIdentifier.getPortIdentifier(portName);
		if (portIdentifier.isCurrentlyOwned()) {
			System.out.println("Error: Port is currently in use");
		} else {
			CommPort commPort = portIdentifier.open(this.getClass().getName(),
					6000);

			if (commPort instanceof SerialPort) {
				SerialPort serialPort = (SerialPort) commPort;
				serialPort.setSerialPortParams(baudRate, SerialPort.DATABITS_8,
						SerialPort.STOPBITS_1, SerialPort.PARITY_NONE);
				serialPort.setFlowControlMode(SerialPort.FLOWCONTROL_NONE);

				InputStream in = serialPort.getInputStream();
				OutputStream out = serialPort.getOutputStream();

				(new Thread(new SerialWriter(out, in))).start();

				serialPort.notifyOnDataAvailable(true);
			} else {
				System.out
						.println("Error: Only serial ports are handled by this example.");
			}
		}

	}

	/** */

	public class SerialWriter implements Runnable {
		OutputStream out;
		InputStream in;

		// SerialPort serialPort;

		public SerialWriter(OutputStream out, InputStream in) {
			this.out = out;
			this.in = in;

		}

		public void run() {
			try {
				String test = "LOOP\n";

				this.out.write(test.getBytes());
				System.out.println("Test the Connection." + test);

				// Read the response...
				System.out.println("Waiting for Test Data ..");

				byte[] buffertest = new byte[99];
				int lentest = -1;
				while ((lentest = in.read(buffertest)) != -1) {

					DavisMessageTranslator translator = new DavisMessageTranslator();
					SensorData data = translator.translateMessage(buffertest);
					adaptor.addData(data);
					
					Thread.sleep(6000);
					
				}

				out.flush();
				out.close();
				in.close();

			} catch (IOException | SensorMessageTranslationException | InterruptedException e) {
				e.printStackTrace();
			}

			/*try {
				Thread.sleep(60000);
			} catch (InterruptedException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}*/

		}
	}

	@Override
	public boolean task(TaskingMessage taskingMessage) {
		// TODO Auto-generated method stub
		return false;
	}

}